<?php

	include "/home/academi1/m-m-ventures.com/academicdating/library.php";



                // ************************************************************************************************************************
                // background task to send emails that have been lodged into the send-email queue, and miscellaneous other background tasks
                // ************************************************************************************************************************

                // Called by Cron once per minute.
                
                // Get up to 4 emails to send from the queue then stop.

                // This gives a capacity of (exactly) 5,760 emails per day.   



                // at present operates two queues, 'live' and 'background'
                
                // will attempt to send 4 emails from the live queue first
                
                // only processes the background queue if there are less than 4 emails waiting in the live queue
                
                

        // NOTE: don't call session_start(), sessions are not available in command-line processes
        
//	$cxn = start_code( true );


	ini_set( "error_log", "/home/academi1/m-m-ventures.com/academicdating/error_log.txt" );

	ini_set( "display_errors", "on" );
	ini_set( "display_startup_errors", "on" );

    error_reporting( E_ALL & ~E_DEPRECATED );

	ini_set( "date.timezone", "Australia/Melbourne" );		


            // set a 10 minute timeout on script execution in case for some reason it doesn't terminate (default is 30 seconds)
            
    set_time_limit( 600 );


	$database = "academi1_academicdating";
	
	$cxn = db_login( $database );

	$cxn_common = db_common_login();


    $attempts = 0;
    
    
            // process live queue first
            
    $attempts = process_email_queue( "emails_to_send_live", $attempts, $cxn, $cxn_common );

    $attempts = process_email_queue( "emails_to_send_background", $attempts, $cxn, $cxn_common );
    
    

		/* clear out old conversations */

	$query = "DELETE FROM active_chats WHERE initiator_id NOT IN (SELECT member_id FROM online_status) OR responder_id NOT IN (SELECT member_id FROM online_status)";

	$result = run_query( $query, $cxn );


		/* clear out old chat text */

	$query = "DELETE FROM chat_text WHERE typed_by NOT IN (SELECT member_id FROM online_status)";

	$result = run_query( $query, $cxn );




    function process_email_queue( $queue_table_name, $attempts, $cxn, $cxn_common )
    {
                // get one message from the queue at a time

    	$query = "SELECT * FROM ".$queue_table_name." ORDER BY id LIMIT 1";

        $result = run_query( $query, $cxn_common );
    
    	while (query_num_rows($result) > 0 && $attempts < 4)
    	{
    		$data = get_row( $result );
    
            $sent = date( "Y-m-d H:i:s" );
    
            $this_site_name = prep_for_sql( $data['site_name'] );
            $this_from_name = prep_for_sql( $data['from_name'] );
            $this_from_addr = prep_for_sql( $data['from_addr'] );
            $this_to_addr = prep_for_sql( $data['to_addr'] );
            $this_reply_name = prep_for_sql( $data['reply_name'] );        
            $this_reply_addr = prep_for_sql( $data['reply_addr'] );        
            $this_subject = prep_for_sql( $data['subject'] );        
            $this_text_body = prep_for_sql( $data['text_body'] );        
            $this_html_body = prep_for_sql( $data['html_body'] );        
    
    
            send_email_actual( $data['from_name'], $data['from_addr'], $data['to_addr'], $data['reply_name'], $data['reply_addr'], $data['subject'], $data['text_body'], $data['html_body'], $cxn, $cxn_common );

    
//    		$query2 = "INSERT INTO emails_actually_sent (site_name, from_name, from_addr, to_addr, reply_name, reply_addr, subject, text_body, html_body, sent) ";
//
//    		$query2 .=" VALUES( '".$this_site_name."', '".$this_from_name."', '".$this_from_addr."', '".$this_to_addr."', '".$this_reply_name."', '".$this_reply_addr."', '".$this_subject."', '".$this_text_body."', '".$this_html_body."', '".$sent."')";
//
//        	$result2 = run_query( $query2, $cxn_common );	    		
    
    
                // because this is multi-user access it's important to delete individual messages that are processed, don't do a bulk delete on a set of records
                // as it may pick up new ones that have been added
    
    	    $query3 = "DELETE FROM ".$queue_table_name." WHERE id = ".$data['id'];
    	    
        	$result3 = run_query( $query3, $cxn_common );	    
        	
        	
        	$query = "SELECT * FROM ".$queue_table_name." ORDER BY id LIMIT 1";
    
            $result = run_query( $query, $cxn_common );
            
            $attempts = $attempts + 1;
    	}

        return ($attempts);
    }

//    echo "ok<br>";

?>