<?php

    define( "online_status_filename", "/home/academi1/m-m-ventures.com/chatcity/online_status/online_status.txt" );
	define( "database_name", "academi1_chatcity" );
	define( "domain", "chatcity1.net" );
	define( "pathroot", "/home/academi1/m-m-ventures.com/chatcity" );
    define( "sitename", "Chat City" );
	define( "common_data_database_name", "academi1_commondata" );

//  the common library include requires:
//    1. edit  /opt/cpanel/ea-php70/root/etc/php.ini
//    2. set allow_url_fopen and allow_url_include to On

	include "/home/academi1/m-m-ventures.com/common_code/common_library.txt";
	include "/home/academi1/m-m-ventures.com/common_code/forms_library.txt";
	include "/home/academi1/m-m-ventures.com/common_code/mail_library.txt";


//	include "/home/academi1/m-m-ventures.com/common_code/common_library.php";
//
//	include "/home/academi1/m-m-ventures.com/common_code/forms_library.php";


    
    			/* startup code to be called at the top of each file */

	function start_code( $first=false, $db="", $is_online_refresh="false" )
	{

			/* set up paths */

		$domain = val( $_SERVER, "HTTP_HOST" );

//		session_save_path( "/home/mlm1/tmp" );
		
		session_start();

		$_SESSION['domain'] = $domain;

		$_SESSION['pathroot'] = "/home/academi1/m-m-ventures.com/chatcity";


			// this variable is used throughout the code for this site

		$_SESSION['http_protocol'] = "http";



			/* set up variables */

		$database = "academi1_chatcity";

        if ($db != "")
		    $database = $db;
		    
        $_SESSION['database'] = $database;
		

        $_SESSION['login_page'] = "login.php";

//        $_SESSION['login_page'] = "login.php";
        

		$user = val( $_GET, "user" );


			/* remember user across pages */

			/* set config options */

		ini_set( "error_log", $_SESSION['pathroot']."/error_log.txt" );

		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

        error_reporting( E_ALL & ~E_DEPRECATED & ~E_WARNING );
        

//		ini_set( "gc_maxlifetime", 3*60*60 );		/* set session timeout to 3 hours */


								// set limits to allow uploading large photos
								
		ini_set( "upload_max_filesize", "16M" );
		ini_set( "post_max_size", "16M" );		
		ini_set( "max_input_time", 300 );		
		ini_set( "max_execution_time'", 300 );		

				
		ini_set( "date.timezone", "Australia/Melbourne" );		

		
		if (! $first )
			check_url();


		$cxn = db_login( $database );


			// redirects user to chat acceptance page if there is a new chat request
			
		if ($is_online_refresh == "false")
			check_for_chat_requests( $cxn );
		
		
//		log_page_load( $cxn, $cxn_common );
		
		return ($cxn);
	}
		
		
		

		/* generate the heading line for a page */

		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $heading, $cxn, $cxn_common, $on_load="", $dont_jump=false, $home_page=false, $bg_color="", $show_top_bar=false )
	{

         $_SESSION['sitename'] = 'Chat City';


			/* redirect to the home page if session is expired */

            // for some reason, selecing Join the Site directly from the home page reloads the home page if this is in use
            
//		if (val( $_SESSION, "session_active" ) != "yes" && $dont_jump == false)
//		{
//			$query = "INSERT INTO sys_log (event, event_datetime) VALUES ('expired_session', '".date("Y-m-d H:i:s")."')";
//			$result = run_query( $query, $cxn );
//
//			jump_to_page( "index.php", "internaljump", "true" );	/* must happen before print output */
//			
//			exit();
//		}

		$_SESSION['session_active'] = "yes";

//		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'><meta http-equiv='expires' content='".date( "D, d M Y", time() - 60*60*24 )." 00:00:00 GMT'>";

		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

        echo "<meta name=\"keywords\" content='Chat,Friendship'>";

		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";


            // page-level mobile ads
            
//        echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>";
//        echo "<script>";
//        echo "  (adsbygoogle = window.adsbygoogle || []).push({";
//        echo "    google_ad_client: 'ca-pub-7728790744816510',";
//        echo "    enable_page_level_ads: true";
//        echo "  });";
//        echo "</script>";


            // the line below should result in the browser checking with the server on each load and downloading a new page if necessary

		echo "<meta http-equiv='cache-control' content='no-cache' >";
		
//        echo "<meta http-equiv='expires' content='0' >";
//        echo "<meta http-equiv='expires' content='Tue, 01 Jan 1980 1:00:00 GMT' >";
//        echo "<meta http-equiv='pragma' content='no-cache' >";		
		
		
			// ********** Notes
			
			// at present only the old version (legacy) of the Google Analytics libary generates Google Translate information
			
            // According to Google Mobile Website Tester, results for mobile home page load time are:
            
            // No analytics: 2 sec
            //  Old analytics library: 4 sec
            //  New analytics library: 5 sec
    
			
//		include "google_analytics_legacy_version.php";

//		include "google_analytics_tracking.php";


		echo '<link rel="apple-touch-icon" sizes="57x57" href="/images/apple-icon-57x57.png">';
		echo '<link rel="apple-touch-icon" sizes="60x60" href="/images/apple-icon-60x60.png">';
		echo '<link rel="apple-touch-icon" sizes="72x72" href="/images/apple-icon-72x72.png">';
		echo '<link rel="apple-touch-icon" sizes="76x76" href="/images/apple-icon-76x76.png">';
		echo '<link rel="apple-touch-icon" sizes="114x114" href="/images/apple-icon-114x114.png">';
		echo '<link rel="apple-touch-icon" sizes="120x120" href="/images/apple-icon-120x120.png">';
		echo '<link rel="apple-touch-icon" sizes="144x144" href="/images/apple-icon-144x144.png">';
		echo '<link rel="apple-touch-icon" sizes="152x152" href="/images/apple-icon-152x152.png">';
		echo '<link rel="apple-touch-icon" sizes="180x180" href="/images/apple-icon-180x180.png">';



			/* javascript functions for chat and online refresh */

		write_js_functions();


			/* define styles */

		
		write_common_styles();
		
		
		$data = define_styles( $home_page );

		$bg = $data['bg'];
		$rose = $data['rose'];
		

//		$bg = "#D9C4AE";		// brown


			// don't override the black background
			
//		if (val( $_SESSION, 'color_scheme' ) != 2)
//			$bg = "#E6E6FA";		// purple
		
				
							// don't override the black background otherwise white text won't show
							
		if ($bg_color != "" && val( $_SESSION, 'color_scheme' ) != 2)
			$bg = $bg_color;

		if ($heading != "")
		{
			if ($on_load != "")
				echo "<title>".$_SESSION['sitename'].": ".$heading."</title></head><body bgcolor='".$bg."' onLoad=\"".$on_load."\">";
			else
				echo "<title>".$_SESSION['sitename'].": ".$heading."</title></head><body bgcolor='".$bg."'>";
		}
		else
		{
		
			if ($on_load != "")
				echo "<title>".$_SESSION['sitename']."</title></head><body bgcolor='".$bg."' onLoad=\"".$on_load."\">";
			else
				echo "<title>".$_SESSION['sitename']."</title></head><body bgcolor='".$bg."'>";
		}


		if ($heading != "")
		{
			if (val( $_SESSION, 'show_language_translation' ) == "on" && low_res_screen())
			{
				echo "<table width='100%'><tr><td width='100%' align='right'>";
				
				show_google_translate();
				
				echo "</td></tr>";
			}


//            if ($show_top_bar && low_res_screen())			
//            {
//					echo "<style> html, body {";
//            		echo "margin:0;";
//            		echo "padding:0;";
//            		echo "}";
//            		echo "</style>";
//            		
//            		echo "<table cellspacing='0' width='100%'><tr><td style='padding-top: 3; padding-bottom: 3; font-family: Calibri; font-size: 13pt; color: #ffffff; background-color: midnightblue' valign='middle' align='center'>Chat City</td></tr></table>";
//            }
		
//	echo "<div style='position: fixed; display: inline-block; width: 100%; background-color: #ffffff;'><br>";
		    
			if (! low_res_screen())       		
			{
    			echo "<table width='100%'><td width='30%'><span class='pgheading' valign='center'>".$heading."</span></td>";
    
    			echo "<td width='10%' valign='center'><a class='redlink' href='".url_encode( "search_profiles.php" )."'>search</a></td>";
    			
    			echo "<td width='10%'></td>";

    			echo "<td width='10%' valign='center'><a class='redlink' href='".url_encode( "mailboxes.php", "box", "inbox" )."'>messages</a></td>";
			}
			else
    			echo "<table width='100%'><td width='60%'><span class='pgheading' valign='center' >".$heading."</span></td>";
    			
			echo "<td width='10%'></td>";

			echo "<td width='5%'></td>";

//				echo "<td width='10%'><img src='".$rose."'></td>";


			if (val( $_SESSION, 'show_language_translation' ) == "on" && (! low_res_screen()))	
			       show_google_translate();


			echo "<td width='20%' align='center'>";
			
			show_green_button( "Home", 80, "index.php", "internaljump", "true" );
			
			echo "</td></table>";
			
//echo "</div>";
			
			echo "<br>";
		}
		else
		{

			if ($home_page == false)
			{
				if (val( $_SESSION, 'show_language_translation' ) == "on" && (! low_res_screen()))	
					echo "<table width='100%'><tr><td width='80%'>&nbsp;</td>";
		
		
				if (val( $_SESSION, 'show_language_translation' ) == "on" && (! low_res_screen()))			
				       show_google_translate();
		
		
				if (val( $_SESSION, 'show_language_translation' ) == "on" && (! low_res_screen()))			
					echo "</tr></table>";
			}
					
		}
	
	
		log_page_view( $cxn, $cxn_common );
	
		
//		echo "ID: ".val( $_SESSION, "id" )."<br>";	
	}


        // log a count of the number of page views. Make sure that this isn't called from online_refresh.php or background email sending program
        
    function log_page_view( $cxn, $cxn_common )
    {

        $ip_country = get_ip_country( $cxn_common );
        
        $today_date = date( "Y-m-d" );
        
        $query = "SELECT * FROM page_views WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."'";
        
        
            // on rare occasions there may be two records created for one date if two users are checking and adding at the same time.
            
        if (query_has_rows( $query, $cxn ))
        {
            $query = "UPDATE page_views SET count = count + 1 WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."'";
            
            $result = run_query( $query, $cxn );
        }
        else
        {
            $query = "INSERT INTO page_views (page_view_date, ip_country, count) VALUES ('".$today_date."', '".$ip_country."', 1 )";
            
            $result = run_query( $query, $cxn );            
        }
    }
    
    
    
		/* define the CSS styles */

	function define_styles( $home_page )
	{
		echo "<style type='text/css'>";

		$color_scheme = val( $_SESSION, 'color_scheme' );

				/* standard */

		if ($color_scheme == "" || $color_scheme == 0 || $color_scheme == 3)
		{
			if ($home_page)
				$bg = '#ffffff';
			else
				$bg = '#ffffff';

			$rose = "images/rose.gif";
			
			echo "body   		{ color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			if (! low_res_screen())
				echo ".hl {cursor: pointer; color: #bb0000; background-color: #e0e0e0; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";
			else
				echo ".hl {cursor: pointer; color: green; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";
				
			echo ".uhl {color: #0000bb; background-color: #f3f3f3; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";

			echo ".gblack         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gblue          { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gblue_l        { color: #0000bb; font-family: verdana; font-size: ".fs( 14 )."pt}";
			echo ".gred           { color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gwatermark     { color: #999999; font-family: verdana; font-size: ".fs( 12 )."pt}";
//			echo ".gpink          { color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".ggreen         { color: #00a600; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".gemail         { color: #ff0000; font-family: courier; font-size: ".fs( 12 )."pt}";
			
			
				// NOTE: if changing the color of the input box border, must also change it in 'write_yellow_input_boxes' as this function
				// sets it back when a field loses the focus

			if (! low_res_screen())
            {				
    			echo ".fprompt        { padding-left: 2px; margin-right: 3px; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
    			echo ".finput         { padding-left: 2px; margin-right: 3px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( 12 )."pt}";			
    			echo ".fradio         { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
    
    			echo ".fprompt_error  { padding-left: 2px; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
    			echo ".finput_error   { padding-left: 2px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
    			echo ".fradio_error   { padding-left: 2px; color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
            }
            else
            {
    			echo ".fprompt        { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
    			echo ".finput         { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( 12 )."pt}";			
    			echo ".fradio         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
    
    			echo ".fprompt_error  { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
    			echo ".finput_error   { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
    			echo ".fradio_error   { color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
            }
            
			echo ".dprompt        { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";          // display prompt
			echo ".dtext          { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";          // display text

			echo ".paraheading    { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".pgheading      { color: #0000bb; font-family: verdana; font-size: ".fs( 16 )."pt}";
			
			if (! low_res_screen())
				echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( 26 )."pt}";			
			else
				echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( 20 )."pt}";
				
			echo ".glink		  { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".glink:visited  { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".glink:link     { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".glink:hover    { color: darkgreen; font-family: verdana; font-size: ".fs( 12 )."pt}";
			
			echo ".redlink:visited { text-decoration: none; color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink:link  { text-decoration: none; color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink:hover { text-decoration: underline; color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".redlink2:visited { color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink2:link  { color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink2:hover { text-decoration: underline; color: green; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".chat		      { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".chat2		      { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";			

		}
		else
		if ($color_scheme == 2)		/* black screen background */
		{
			$bg = '#000000';
			$rose = "images/roseb.gif";
			
			echo "body   		{ color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			if (! low_res_screen())	
				echo ".hl {cursor: pointer; background-color: #eeeeee; color: #bb0000; font-size:".fs( 11 )."pt; font-family: Times; text-decoration:none}";
			else
				echo ".hl {cursor: pointer; color: #bb0000; font-size:".fs( 11 )."pt; font-family: Times; text-decoration:none}";			
			
			echo ".uhl {color: #aaaaff; font-size:".fs( 11 )."pt; font-family: Times; text-decoration:none}";

			echo ".gblack         { color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gblue          { color: #aaaaff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gblue_l        { color: #aaaaff; font-family: Times; font-size: ".fs( 14 )."pt}";
			echo ".gred           { color: #ff0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gwatermark     { color: #999999; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".gemail         { color: #ffaaaa; font-family: Courier; font-size: ".fs( 12 )."pt}";
			
			echo ".fprompt        { color: #aaaaff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: Times; font-size: ".fs( 12 )."pt}";
			
			echo ".fradio         { color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { color: #ff0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { color: #000000; background-color: #ff9999; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".dprompt        { color: #aaaaff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".dtext          { color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".paraheading    { color: #aaaaff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".pgheading      { color: #aaaaff; font-family: Times; font-size: ".fs( 16 )."pt}";
			
			if (! low_res_screen())			
				echo ".homeheading    { color: #ff0000; font-family: Times; font-size: ".fs( 22 )."pt}";
			else
				echo ".homeheading    { color: #ff0000; font-family: Times; font-size: ".fs( 20 )."pt}";
				
			echo ".glink		  { color: #aaaaff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:visited  { color: #aaaaff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:link     { color: #aaaaff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:hover    { color: darkgreen; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".redlink:visited { text-decoration: none; color: #ff0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".redlink:link  { text-decoration: none; color: #ff0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".redlink:hover { text-decoration: underline; color: #ff0000; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".redlink2:visited { color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink2:link  { color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink2:hover { text-decoration: underline; color: green; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".chat		      { color: #ffffff; font-family: Arial; font-size: ".fs( 12 )."pt}";
			echo ".chat2		      { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";						
		}
		else
		if ($color_scheme == 1)		/* pink italics */
		{
//			if ($home_page)
//				$bg = '#008200';
//			else
				$bg = '#ffffff';

			$rose = "images/rose.gif";

			echo "body   		{ color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";

			if (! low_res_screen())
				echo ".hl {cursor: pointer; color: #bb0000; background-color: #eeeeee; font-family: Arial; font-size: ".fs( 11 )."pt; font-style: italic; }";
			else
				echo ".hl {cursor: pointer; color: #ee0000; font-family: Arial; font-size: ".fs( 11 )."pt; font-style: italic; }";
				
			echo ".uhl { color: #FF69B4; font-family: Arial; font-size: ".fs( 11 )."pt; font-style: italic; }";

			
			echo ".gblack         { color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gblue          { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gblue_l        { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 14 )."pt}";
			echo ".gred           { color: #ff0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gwatermark     { color: #999999; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".gemail         { color: #ff0000; font-family: Courier; font-size: ".fs( 12 )."pt}";
			
			echo ".fprompt        { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: Times; font-size: ".fs( 12 )."pt}";
			
			echo ".fradio         { color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { color: #ff0000; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { color: #000000; background-color: #ff9999; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".dprompt        { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";    
			echo ".dtext          { color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";                        

			echo ".paraheading    { color: #FF69B4; ; font-style: italic; font-family: Times; font-size: ".fs( 11 )."pt}";

			echo ".pgheading      { color: #0000ff; font-family: Times; font-size: ".fs( 16 )."pt}";

			if (! low_res_screen())			
				echo ".homeheading    { color: #ff0000; font-family: Times; font-size: ".fs( 22 )."pt}";
			else
				echo ".homeheading    { color: #ff0000; font-family: Times; font-size: ".fs( 20 )."pt}";

			echo ".glink		  { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:visited  { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:link     { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:hover    { color: darkgreen; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".redlink:visited { text-decoration: none; color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink:link  { text-decoration: none; color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink:hover { text-decoration: underline; color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".redlink2:visited { color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink2:link  { color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink2:hover { text-decoration: underline; color: green; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".chat		      { color: #000000; font-family: Arial; font-size: ".fs( 12 )."pt}";
			echo ".chat2		      { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";						
		}

		echo "</style>";

			/* mouseover highlight bar */

		echo "<script>";
		echo "function hl( idx )	{	document.getElementById(idx).className = \"hl\"; }";
		echo "function uhl( idx )	{	document.getElementById(idx).className = \"mainmenuitem\"; }";		
		echo "</script>";

		$data['bg'] = $bg;
		$data['rose'] = $rose;

		return ($data);
	}



		// write a record to the 'page_loads' table for each page loaded, if called
		
	function log_page_load( $cxn, $cxn_common )
	{
		$ip_address = get_ip_address();	
		
		$ip_country = get_ip_country( $cxn_common );
		
		$loaded_datetime = date("Y-m-d H:i:s");
		
		$page = val( $_SERVER, "PHP_SELF" );
		
		$query = "INSERT INTO page_loads (ip_address, ip_country, loaded, page) VALUES ('".$ip_address."', '".$ip_country."', '".$loaded_datetime."', '".$page."')";
		
		$result = run_query( $query, $cxn );		
	}


	function show_photo( $member_id, $height, $photo_number, $allow_zoom, $large, $cxn )
	{
		if ($photo_number == -1)
			$query = "SELECT * FROM photos WHERE member_id = ".$member_id." AND primary_photo = 'yes'";
		else
			$query = "SELECT * FROM photos WHERE member_id = ".$member_id." AND photo_number = ".$photo_number;

		$result = run_query( $query, $cxn );

		if (query_num_rows($result) == 0)
		{
			if ($height == 120)
				$filename = url_encode_file( "photos/v1_no_photo_120.gif" );
			else
			if ($height == 100)
				$filename = url_encode_file( "photos/v1_no_photo_100.gif" );
			else
			if ($height == 80)
				$filename = url_encode_file( "photos/v1_no_photo_80.gif" );
			else
//				$filename = url_encode_file( "photos/no_photo.gif" );
				$filename = url_encode_file( "photos/v1_no_photo_100.gif" );
				
			echo "<img src='".$filename."' width='".$height."' height='".$height."'>";
		}
		else
		{
			$data = get_row( $result );

			$width = $height * $data['aspect_ratio'];
			
			$version = $data['version'];
			
			
			    // allow for revised versions of photos due to rotating them etc.
			    
			if ($version == "")
			    $version_str = "";
			else
			    $version_str = "_v".$version;

			if ($large)
				$filename = "/photos/photo_".$member_id."_".$data['photo_number']."_l".$version_str.".".$data['file_extension'];
			else
				$filename = "/photos/photo_".$member_id."_".$data['photo_number']."_sm".$version_str.".".$data['file_extension'];

			if ($allow_zoom)
			{
				echo "<a href='".url_encode( "show_large_photo.php", "showid", $member_id, "photonumber", $photo_number )."'>";
				echo "<img alt='Member Photo' src='".url_encode_file( $filename )."' width='".$width."' height='".$height."' border='0'>";
				echo "</a>";
			}
			else
				echo "<img alt='Member Photo' src='".url_encode_file( $filename )."' width='".$width."' height='".$height."'>";
		}
	}



	function show_photo_ad( $member_id, $height, $photo_number, $allow_zoom, $large, $cxn )
	{
        if ($large)
    	    $height = 380;
        else
    	    $height = 125;


		if ($photo_number == -1)
			$query = "SELECT * FROM academi1_academicdating.photos WHERE member_id = ".$member_id." AND primary_photo = 'yes'";
		else
			$query = "SELECT * FROM academi1_academicdating.photos WHERE member_id = ".$member_id." AND photo_number = ".$photo_number;

		$result = run_query( $query, $cxn );

		if (query_num_rows($result) == 0)
		{
            show_no_photo( $height );
		}
		else
		{
			$data = get_row( $result );
		    
            show_photo_info_ad( $member_id, $allow_zoom, $large, $data['photo_number'], $data['file_extension'], $data['aspect_ratio'], $data['version'] );
		}
	}



	function show_photo_info_ad( $member_id, $allow_zoom, $large, $photo_number, $file_extension, $aspect_ratio, $version )
	{
        if ($large)
    	    $height = 380;
        else
    	    $height = 125;
	    
	    
        if ($photo_number == "")
		{
            show_no_photo( $height );
		}
		else
		{
			$width = $height * $aspect_ratio;
			
			    // allow for revised versions of photos due to rotating them etc.
			    
			if ($version == "")
			    $version_str = "";
			else
			    $version_str = "_v".$version;

			if ($large)
				$filename = "https://academicdating.net/".get_photos_url_pathroot( $member_id )."/photo_".$member_id."_".$photo_number."_l".$version_str.".".$file_extension;
			else
				$filename = "https://academicdating.net/".get_photos_url_pathroot( $member_id )."/photo_".$member_id."_".$photo_number."_sm".$version_str.".".$file_extension;

			if ($allow_zoom)
			{
				echo "<a href='".url_encode( "/show_large_photo.php", "showid", $member_id, "photonumber", $photo_number )."'>";
				echo "<img alt='Member Photo' src='".url_encode_file( $filename )."' width='".$width."' height='".$height."' border='0'>";
				echo "</a>";
			}
			else
				echo "<img alt='Member Photo' src='".url_encode_file( $filename )."' width='".$width."' height='".$height."'>";
		}
	}


      // return the path to a photo file  
  
    function get_photos_url_pathroot( $member_id )
    {
        $tag = floor( $member_id / 5000 ) * 5000;
        
        $photo_pathroot = "/photos/photos_".$tag;

        return ($photo_pathroot);
    }


	function additional_validations( $id, $form_name, $newrecord, &$validation_errors, &$screen_data, &$screen_data_error, $cxn, $cxn_common )
	{

//		if ($form_name == "alert_details")	
//		{
//          if ($screen_data['min_age'] != "" && $screen_data['max_age'] != "" && $screen_data['min_age'] > $screen_data['max_age'])
//			{
//				$validation_errors = $validation_errors."The minimum search age cannot be greater than the maximum search age<br>";
//				
//				$screen_data_error['min_age'] = "true";
//				$screen_data_error['max_age'] = "true";				
//			}
//		}

            // allow contact details if the site is free
            
//		if ($form_name == "profile")	
//		{
//          if (check_for_phone_number( $screen_data['interests'] ))
//			{
//				$validation_errors = $validation_errors."Your profile cannot contain numbers such as a whatsapp number<br>";
//				$screen_data_error['interests'] = "true";
//			}
//
//          if (strpos( $screen_data['interests'], "@" ) !== false)
//		    {
//				$validation_errors = $validation_errors."Your profile cannot contain an email address<br>";
//				$screen_data_error['interests'] = "true";
//			}
//
//
//          if (check_for_phone_number( $screen_data['general_comments'] ))
//          {
//				$validation_errors = $validation_errors."Your profile cannot contain numbers such as a whatsapp number<br>";
//				$screen_data_error['general_comments'] = "true";
//			}
//
//          if (strpos( $screen_data['general_comments'], "@" ) !== false)
//			{
//				$validation_errors = $validation_errors."Your profile cannot contain an email address<br>";
//				$screen_data_error['general_comments'] = "true";
//			}
//
//
//          if (check_for_phone_number( $screen_data['looking_for'] ))
//			{
//				$validation_errors = $validation_errors."Your profile cannot contain numbers such as a whatsapp number<br>";
//				$screen_data_error['looking_for'] = "true";
//			}
//			
//          if (strpos( $screen_data['looking_for'], "@" ) !== false)
//			{
//				$validation_errors = $validation_errors."Your profile cannot contain an email address<br>";
//				$screen_data_error['looking_for'] = "true";
//			}
//
//      }

		
		if ($form_name == "chat_city_profile")	
		{
			$handle = $screen_data['handle'];		
			
			if ($handle != "")
			{
				if (! check_handle( $newrecord, $handle, $id, $cxn ))
				{
					$validation_errors = $validation_errors."This handle name has already been used by an existing member<br>";
					$screen_data_error['handle'] = "true";
				}
			}


//          if (check_for_phone_number( $screen_data['handle'] ))
//			{
//				$validation_errors = $validation_errors."Your handle name cannot contain multiple digits such as a whatsapp number<br>";
//				$screen_data_error['handle'] = "true";
//			}
//
//          if (strpos( $screen_data['handle'], "@" ) !== false)
//			{
//				$validation_errors = $validation_errors."Your handle name cannot contain an email address<br>";
//				$screen_data_error['handle'] = "true";
//			}
//
//
//          if (check_for_phone_number( $screen_data['short_intro'] ))
//			{
//				$validation_errors = $validation_errors."Your profile cannot contain numbers such as a whatsapp number<br>";
//				$screen_data_error['short_intro'] = "true";
//			}
//
//          if (strpos( $screen_data['short_intro'], "@" ) !== false)
//			{
//				$validation_errors = $validation_errors."Your profile cannot contain an email address<br>";
//				$screen_data_error['short_intro'] = "true";
//			}


			$email_address = $screen_data['email'];		
			
			if ($email_address != "")
			{
								// the validity of an email address here is according to PHPMailer which is the package
					// currently used for sending

//				if (strpos( $email_address, "@" ) === false || strpos( $email_address, "." ) === false)

				if (email_address_is_valid( $email_address ) == "false")
				{
					$validation_errors = $validation_errors."The email address that you have entered is not a valid email address<br>";
					$screen_data_error['email'] = "true";
				}
			}
			
//			if ($screen_data['wants_relationship'] != "on" && $screen_data['wants_friendships'] != "on")
//			{
//				$validation_errors = $validation_errors."You have not selected a tickbox to indicate whether you are looking for a relationship or friendships or both<br>";
//	
//				$screen_data_error['wants_relationship'] = "true";
//				$screen_data_error['wants_friendships'] = "true";
//			}	
	
	
//			if ($screen_data['accepts_conditions'] != "on")
//			{
//				$validation_errors = $validation_errors."You must tick the checkbox at the bottom of the page signifying that you accept the conditions of use of this website.<br>";
//	
//				$screen_data_error['accepts_conditions'] = "true";
//			}
		
		
					// get the date format or default to dd/mm/yyyy
				
			$date_format = $screen_data['date_format'];
			
			if ($date_format == "")
				$date_format = "dd/mm/yyyy";
	
			if ($screen_data['date_of_birth'] != "" && $date_format != "")
			{
				$age = check_date( convert_date_of_birth(prep_for_sql( $screen_data['date_of_birth'] ), str_replace( "'", "''", $date_format), $cxn ), $cxn);
		
				if ($age == 0)
				{
					$validation_errors = $validation_errors."The date of birth is not in a valid format. Please enter it in the format dd/mm/yyyy, mm/dd/yyyy or yyyy/mm/dd and select the format that you have used from the 'date format' list<br>";
	
					$screen_data_error['date_of_birth'] = "true";				
					$screen_data_error['date_format'] = "true";				
				}
				else
				if ($age < 18)
				{
					$validation_errors = $validation_errors."You must be at least 18 years of age to join this site<br>";
					
					$screen_data_error['date_of_birth'] = "true";				
					$screen_data_error['date_format'] = "true";				
				}
				else
				if ($age > 110)
				{
					$validation_errors = $validation_errors."Your date of birth may be incorrect, it is indicating you as over 110 years old<br>";
					
					$screen_data_error['date_of_birth'] = "true";				
					$screen_data_error['date_format'] = "true";				
				}
		
			}
		}
		
	}

			/* check to see whether a new user has selected an existing handle */

	function check_handle($newprofile, $handle, $id, $cxn)
	{
		$handle = str_replace( "'", "''", $handle);

		if ($newprofile == "true")
			$query = "SELECT handle FROM handle_history WHERE handle = '".$handle."'";
		else
			$query = "SELECT handle FROM handle_history WHERE handle = '".$handle."' AND member_id <> ".$id;

		$result = run_query( $query, $cxn );

		if (query_num_rows($result) == 0)
			return true;
		else
			return false;
	}


	function additional_screen_initialisations( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn, $cxn_common )
	{

//		if ($form_name == "profile" && $newrecord == "true")			
//            $screen_data['receive_new_member_update_email'] = "monthly";
            

			// the following code is needed if those fields are put back on the form.

		if ($form_name == "chat_city_profile")
		{
			$screen_data['confirm_email'] = $screen_data['email'];
			
//			$screen_data['confirm_password'] = $screen_data['password'];
		}

//		if ($form_name == "profile" || $form_name == "adquickjoin")		
//		{
//			if ($newrecord == "false")
//				$screen_data['accepts_conditions'] = "on";
//		}


        if ($screen_data['sex'] == "Male")
            $screen_data['sex_and_seeking'] = "Man";
        else
        if ($screen_data['sex'] == "Female")
            $screen_data['sex_and_seeking'] = "Woman";
	}
	

		// don't delete this function it is called by the general save function
		
	function additional_changes_before_database_save( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn, $cxn_common )
	{
		if ($form_name == "alert_details" && $newrecord == "true")
		{
			$id = val( $_SESSION, "id" );
			
			$screen_data['member_id'] = $id;
		}
	}



		// don't put in the common library because there is a different tracking ID for each site
		
	function show_google_translate()
        {
		echo "<td width='15%' valign='top'>";
		echo ' <div id="google_translate_element"></div><script type="text/javascript"> ';
		echo ' function googleTranslateElementInit() { ';
//		echo " new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE, gaTrack: true, gaId: 'UA-97849346-1'}, 'google_translate_element'); ";		
		echo " new google.translate.TranslateElement({pageLanguage: 'en', gaTrack: true, gaId: 'UA-97849346-1'}, 'google_translate_element'); ";				
		echo ' } ';
		echo ' </script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> ';
		echo "</td>";
        }



		/* send the email to the user allowing them to verify their email address */
		
		// NOTE: can't use SESSION variables here as this is called from a background process

	function send_verification_email( $id, $email_verification_code, $cxn, $cxn_common )
	{
		$first_name = "";
	
		$query = "SELECT handle, first_name FROM profile WHERE id = ".$id;

		if (query_has_rows( $query, $cxn ))
		{
			$result = run_query( $query, $cxn );
			$data = get_row( $result );
			$first_name = first_name_or_handle( $data );
		}

		$subject = "Verification email from Chat City";

		$url = url_encode( "http://chatcity1.net/verify_email.php", "verifyid", $id, "code", $email_verification_code );
		
		$text_body = "Hi ".$first_name.",\n\nThank you for joining Chat City.\n\nTo activate your account please copy and paste the following text into your browser address bar and press enter\n\n";
		$text_body .= $url;

		$text_body .= "If the link does not work when you click on it please copy and paste the following text into your browser address bar and press enter:<br><br>";
		
		$text_body .= $url;


		$html_body = "Hi ".$first_name.",<br><br>Thank you for joining Chat City.<br><br>To activate your account please click on the link below<br><br>";

		$html_body .= "<a href='".$url."'>activate account</a><br><br><br><br>";		
		
		$html_body .= "If the link does not work when you click on it please copy and paste the following text into your browser address bar and press enter:<br><br>";
		
		$html_body .= $url;
		

		return (send_external( $id, $subject, $text_body, $html_body, $cxn, $cxn_common, "live" ));
	}




	
		// select an image to show on the home page depedant on region
		
	function select_website_image( $cxn, $cxn_common )
	{	
		$ip_country = get_ip_country( $cxn_common );
		$ip_country = str_replace( "'", "", $ip_country );

		$query = "SELECT photo_type FROM country WHERE ip_address_name = '".$ip_country."'";

		$result = run_query( $query, $cxn_common );

		if (query_num_rows( $result ) == 0)
			$photo_type = "white";
		else
		{
			$data = get_row( $result );
			
			$photo_type = $data['photo_type'];		
		}

		if ($photo_type == "arab")		// don't show arabic photos for security
			$photo_type = "white";


//		$photo_type = "african";

			
		$random_photo_number = rand(0,100);

		$image = "images/couple_freestock_41630947_2.jpg";
		
		return ($image);
		
				
		if ($photo_type == "african")		
		{
//			if ($random_photo_number <= 20)
//				$image = "images/african_couple_1.jpg";
//			else
//			if ($random_photo_number <= 40)
//				$image = "images/african_couple_2.jpg";
//			else
//			if ($random_photo_number <= 60)
//				$image = "images/african_couple_3.jpg";
//			else
//			if ($random_photo_number <= 80)
//				$image = "images/african_couple_4.jpg";
//			else
//				$image = "images/african_couple_5.jpg";
//

				$image = "images/african_couple_3.jpg";
		}
		else
		if ($photo_type == "asian")
		{
//			if ($random_photo_number <= 20)
//				$image = "images/asian_couple_1.jpg";
//			else
//			if ($random_photo_number <= 40)
//				$image = "images/asian_couple_2.jpg";
//			else
//			if ($random_photo_number <= 60)
//				$image = "images/asian_couple_3.jpg";
//			else
//			if ($random_photo_number <= 80)
//				$image = "images/asian_couple_4.jpg";
//			else
//				$image = "images/asian_couple_5.jpg";

			$image = "images/asian_couple_2.jpg";
		}
		else
		if ($photo_type == "arab")
		{
			if ($random_photo_number <= 20)
				$image = "images/arab_couple_dreamstime_xs_36959586.jpg";
			else
			if ($random_photo_number <= 40)
				$image = "images/arab_couple_dreamstime_xs_63085331.jpg";
			else
			if ($random_photo_number <= 60)
				$image = "images/arab_couple_dreamstime_xs_66060264.jpg";
			else
			if ($random_photo_number <= 80)
				$image = "images/arab_couple_dreamstime_xs_71867492.jpg";
			else
				$image = "images/arab_couple_dreamstime_xs_80580750.jpg";
		
		}
		else

//		if ($photo_type == "white")

		{
		
//			if ($random_photo_number <= 20)
//				$image = "images/couple_freestock_36325414.jpg";
//			else
//			if ($random_photo_number <= 40)
//				$image = "images/couple_freestock_24256453.jpg";
//			else
//			if ($random_photo_number <= 60)
//				$image = "images/couple_freestock_113104756.jpg";
//			else
//			if ($random_photo_number <= 80)

//				$image = "images/couple_freestock_135667358.jpg";
				
//			else
//				$image = "images/couple_freestock_75384427.jpg";

				$image = "images/couple_freestock_36325414.jpg";	
				
//				$image = "images/couple_freestock_113104756_sm.jpg";

		}
		
		return ($image);
	}



		// second image, for search screen
		
	function select_website_image2( $cxn, $cxn_common )
	{	
		$ip_country = get_ip_country( $cxn_common );
		$ip_country = str_replace( "'", "", $ip_country );

		$query = "SELECT photo_type FROM country WHERE ip_address_name = '".$ip_country."'";

		$result = run_query( $query, $cxn_common );

		if (query_num_rows( $result ) == 0)
			$photo_type = "white";
		else
		{
			$data = get_row( $result );
			
			$photo_type = $data['photo_type'];		
		}

		if ($photo_type == "arab")		// don't show arabic photos for security
			$photo_type = "white";


//		$photo_type = "african";
		
						
		$random_photo_number = rand(0,100);
		

		if ($photo_type == "african")		
		{
//			if ($random_photo_number <= 20)
//				$image = "images/african_couple_1.jpg";
//			else
//			if ($random_photo_number <= 40)
//				$image = "images/african_couple_2.jpg";
//			else
//			if ($random_photo_number <= 60)
//				$image = "images/african_couple_3.jpg";
//			else
//			if ($random_photo_number <= 80)
//				$image = "images/african_couple_4.jpg";
//			else
//				$image = "images/african_couple_5.jpg";
//
				
			$image = "images/african_couple_2_sm.jpg";

//			$image = "images/african_couple_5_sm.jpg";
						
		}
		else
		if ($photo_type == "asian")
		{
//			if ($random_photo_number <= 20)
//				$image = "images/asian_couple_1.jpg";
//			else
//			if ($random_photo_number <= 40)
//				$image = "images/asian_couple_2.jpg";
//			else
//			if ($random_photo_number <= 60)
//				$image = "images/asian_couple_3.jpg";
//			else
//			if ($random_photo_number <= 80)
//				$image = "images/asian_couple_4.jpg";
//			else
//				$image = "images/asian_couple_5.jpg";

			$image = "images/asian_couple_3_sm.jpg";
		}
		else
		if ($photo_type == "arab")
		{
			if ($random_photo_number <= 20)
				$image = "images/arab_couple_dreamstime_xs_36959586.jpg";
			else
			if ($random_photo_number <= 40)
				$image = "images/arab_couple_dreamstime_xs_63085331.jpg";
			else
			if ($random_photo_number <= 60)
				$image = "images/arab_couple_dreamstime_xs_66060264.jpg";
			else
			if ($random_photo_number <= 80)
				$image = "images/arab_couple_dreamstime_xs_71867492.jpg";
			else
				$image = "images/arab_couple_dreamstime_xs_80580750.jpg";
		
		}
		else

//		if ($photo_type == "white")

		{
		
//			if ($random_photo_number <= 20)
//				$image = "images/couple_freestock_36325414.jpg";
//			else
//			if ($random_photo_number <= 40)
//				$image = "images/couple_freestock_24256453.jpg";
//			else
//			if ($random_photo_number <= 60)
//				$image = "images/couple_freestock_113104756.jpg";
//			else
//			if ($random_photo_number <= 80)
//				$image = "images/couple_freestock_135667358.jpg";
//			else
//				$image = "images/couple_freestock_75384427.jpg";


			$image = "images/couple_freestock_75384427_sm.jpg";

		}
		
		return ($image);
	}

	
		// Don't put this function in the common library because it's different for SSL and non SSL connections
		
		/* log into the database and return the connection */
		

	function db_login( $database )
	{
			// azure login credentials
		
//		$host="mlmlocalhost.mysql.database.azure.com";
//		$user="mlm1@mlmlocalhost";
//		$password="Tree$%12";
		
		$host="localhost";
		$user="academi1_mlm1";
		$password="plastic1";


        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn->connect_errno."<br>";
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}




		// Log into the common database. Must happen AFTER the login to the normal local database $cxn as it's set up for this
		// function only to create a second connection
		
	function db_common_login()
	{
		$host="localhost";
		$user="academi1_mlm1";
		$password="plastic1";

        $cxn_common = new mysqli( $host, $user, $password, "academi1_commondata" );
      
		if ($cxn_common->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn_common->connect_errno."<br>";
			echo "Error text: ".$cxn_common->connect_error."<br>";

			exit();
		}

		return $cxn_common;
	}	

		/* send an email to a member */

	function send_external( $to_id, $subject, $text_body, $html_body, $cxn, $cxn_common, $queue )
	{
		$from_name = $_SESSION['sitename'];
		$from_addr = "noreply@chatcity1.net";
		$reply_name = $_SESSION['sitename'];
		$reply_addr = "noreply@chatcity1.net";

		$query = "SELECT email FROM profile WHERE id = ".$to_id;

		$result = run_query( $query, $cxn );

		$data = get_row( $result );


		$domain = val( $_SERVER, "HTTP_HOST" );

		$to_addr = $data['email'];

		send_email( $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body, $cxn, $queue );

		return ($to_addr);
	}



	function show_ads( $cxn, $show_extra=true, $home_page=false )
	{
		show_ads_1_line( $home_page );
	}


		// show 2 banner ads per page
		
	function show_double_ads( $cxn )
	{
		show_ads_1_line( "false" );
			
		echo "<br><br>";
		
		show_ads_1_line( "false" );			
	}
	
	

	function show_ads_1_line( $home_page )
	{
		echo "<table width='100%'><tr><td width='15%'></td><td>".watermark( sp(10)."Advertisement" )."</td><tr><td></td><td align='center'>\n";

			// 'repsonsive' ad a unit that adjusts to page size

		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n";
		echo "<!-- New Ads 2 (Chat City) -->\n ";
		echo "<ins class='adsbygoogle'\n";
		echo "style='display:block'\n";
		echo "data-ad-client='ca-pub-7728790744816510'\n";
		echo "data-ad-slot='3690143554'\n";
		echo "data-ad-format='auto'></ins>\n";
		echo "<script>\n";
		echo "(adsbygoogle = window.adsbygoogle || []).push({});\n";
		echo "</script>\n";

		echo "</td><td width='15%'></td></tr></table>\n";
	}


		// suitable for desktop, and mobile when most of the page is available
		
	function show_ads_large_square()
	{
        echo black( "&nbsp;&nbsp;Advertisement" );
	    
		echo " <script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n ";
		echo " <!-- New Ads 2 Large Square (Chat City) -->\n ";
		echo " <ins class='adsbygoogle'\n ";
		echo "     style='display:inline-block;width:336px;height:280px'\n ";
		echo "     data-ad-client='ca-pub-7728790744816510'\n ";
		echo "     data-ad-slot='6631824055'></ins>\n ";
		echo " <script>\n ";
		echo " (adsbygoogle = window.adsbygoogle || []).push({});\n ";
		echo " </script>\n ";

	}

	
		// this ad unit is for mobile phones
		
	function show_ads_narrow_banner()
	{	
	    return;

	    
        echo black( "&nbsp;&nbsp;Advertisement" );
        
		echo "<table width='100%'><tr><td align='center'>\n";
		
		echo " <script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n ";
		echo " <!-- New Ads 2 Narrow Banner (Chat City) -->\n ";
		echo " <ins class='adsbygoogle'\n ";
		echo "      style='display:inline-block;width:320px;height:100px'\n ";
		echo "      data-ad-client='ca-pub-7728790744816510'\n ";
		echo "      data-ad-slot='3474521135'></ins>\n ";
		echo " <script>\n ";
		echo " (adsbygoogle = window.adsbygoogle || []).push({});\n ";
		echo " </script>\n ";
		
		echo "</td></tr></table>\n";		
	}


		// this ad unit is for desktop
		
	function show_ads_narrow_skyscraper()
	{
	    return;

	    
        echo watermark( "Advertisement<br>" );
        
		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>";
		echo "<!-- New Ads 2 Narrow Skyscraper (Chat City) -->";
		echo "<ins class='adsbygoogle'";
		echo "     style='display:inline-block;width:120px;height:600px'";
		echo "     data-ad-client='ca-pub-7728790744816510'";
		echo "     data-ad-slot='3282949447'></ins>";
		echo "<script>";
		echo "(adsbygoogle = window.adsbygoogle || []).push({});";
		echo "</script>";
	}
	


		// this ad unit is for desktop
		
	function show_ads_medium_skyscraper()
	{
        echo watermark( "Advertisement<br>" );
        
		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>";
		echo "<!-- New Ads 2 Medium Skyscraper (Chat City) -->";
		echo "<ins class='adsbygoogle'";
		echo "     style='display:inline-block;width:160px;height:600px'";
		echo "     data-ad-client='ca-pub-7728790744816510'";
		echo "     data-ad-slot='3322300281'></ins>";
		echo "<script>";
		echo "(adsbygoogle = window.adsbygoogle || []).push({});";
		echo "</script>";
		
	}
	


		// this ad unit is for desktop
		
	function show_ads_small_banner()
	{
	    return;

	    
        echo watermark( "Advertisement<br>" );
        
		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>";
		echo "<!-- New Ads 2 Small Banner (Chat City) -->";
		echo "<ins class='adsbygoogle'";
		echo "     style='display:inline-block;width:468px;height:60px'";
		echo "     data-ad-client='ca-pub-7728790744816510'";
		echo "     data-ad-slot='5550020137'></ins>";
		echo "<script>";
		echo "(adsbygoogle = window.adsbygoogle || []).push({});";
		echo "</script>";
	}
	
	
	

	function first_name_or_handle( $data )
	{
		if (val( $data, 'first_name' ) != "")
			return ($data['first_name']);
		else
			return ($data['handle']);
	}


	function get_site_num_members( $cxn )
	{
		if (val( $_SESSION, "site_number_of_members" ) != "")
			$site_num_members = val( $_SESSION, "site_number_of_members" );
		else
		{
			$data = get_first_row( "SELECT count(*) as num FROM profile WHERE deleted = 'no' and system_user = 'no'", $cxn );
		
			$site_num_members = number_format( $data['num'] );
		
			$_SESSION['site_number_of_members'] = $site_num_members;
		}
		
		return ($site_num_members);
	}
	

	function get_site_num_active_members( $cxn )
	{

		if (val( $_SESSION, "site_number_of_active_members" ) != "")
			$site_number_of_active_members = val( $_SESSION, "site_number_of_active_members" );
		else
		{

		    $today_date = date_create( date("Y-m-d") );

        	$today_minus_365_days = clone $today_date;

        	date_sub( $today_minus_365_days, date_interval_create_from_date_string( '365 days' ));
        	
	        $today_minus_365_days_str = $today_minus_365_days->format( "Y-m-d" );		

			$data = get_first_row( "SELECT count(*) as num FROM profile WHERE deleted = 'no' and system_user = 'no' and last_login >= '".$today_minus_365_days_str."'", $cxn );

			$site_number_of_active_members = number_format( $data['num'] );
			

    		$_SESSION['site_number_of_active_members'] = $site_number_of_active_members;
		}
		
		return ($site_number_of_active_members);
	}



	function get_site_num_countries( $cxn )
	{
		if (val( $_SESSION, "site_number_of_countries" ) != "")
			$site_num_countries = val( $_SESSION, "site_number_of_countries" );
		else
		{
			$query = "SELECT count(*) as num FROM (SELECT DISTINCT country FROM profile WHERE deleted = 'no' and system_user = 'no') x";
			$result = run_query( $query, $cxn );
			$data = get_row( $result );
		
    		$site_num_countries = $data['num'];

			$_SESSION['site_number_of_countries'] = $site_num_countries;
		}
	
		return ($site_num_countries);
	}



	function get_site_num_active_countries( $cxn )
	{
	    
		if (val( $_SESSION, "site_num_active_countries" ) != "")
			$site_num_active_countries = val( $_SESSION, "site_num_active_countries" );
		else
		{
	        $today_date = date_create( date("Y-m-d") );

        	$today_minus_365_days = clone $today_date;

        	date_sub( $today_minus_365_days, date_interval_create_from_date_string( '365 days' ));
        	
	        $today_minus_365_days_str = $today_minus_365_days->format( "Y-m-d" );		
		    
		    
			$query = "SELECT count(*) as num FROM (SELECT DISTINCT country FROM profile WHERE deleted = 'no' and system_user = 'no' and last_login >= '".$today_minus_365_days_str."') x";
			$result = run_query( $query, $cxn );
			$data = get_row( $result );
		
			$site_num_active_countries = $data['num'];
			

			$_SESSION['site_num_active_countries'] = $site_num_active_countries;
		}
	
		return ($site_num_active_countries);
	}


		// don't put in the common library because different sites have different color schemes
		
	function form_start( $handler, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="" )
	{
			//lightskyblue  #cceeff azure
			// lighter color first #c0f5ff
			// azure, lightblue

		$color_scheme = val( $_SESSION, "color_scheme" );
		                                                                    // box-shadow: 10px 10px 5px #888888;
		if ($color_scheme != 2)		/* black screen background */
//			echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(#fcfcfc, #e1e1e1); '>\n";
			echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: #fcfcfc;); '>\n";
		else
			echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table style='border: 1px solid #bbbbbb; '>\n";
		
	}



		// must happen before printed output
		
	function check_for_chat_requests( $cxn )
	{
		$id = val( $_SESSION, "id" );
		
		if ($id != "")
		{
			$query = "SELECT * FROM active_chats WHERE responder_id = ".$id." AND notified = 'no'";

			if (query_has_rows( $query, $cxn ))
			{
				$result = run_query( $query, $cxn );
		
				$data = get_row( $result );
				
				$initiator_id = $data['initiator_id'];
				
				$query = "UPDATE active_chats SET notified = 'yes' WHERE responder_id = ".$id." AND initiator_id = ".$initiator_id;

				$result = run_query( $query, $cxn );
			
                session_write_close();			
                
				header( "Location: chat_request.php?requestingid=".$initiator_id );
				
				exit();
			}
		}
	}



        // show the menu bar for the FAQ, Policies etc pages
        
	function show_info_menu( $cxn )
	{
		$bg = "#73b8bb";

        echo "<style>";
        echo "table.infomenubartable td {";
        echo "    color: #000000;";
//        echo "    line-height: 25pt;";
        echo "    font-size: ".fs( 12) ."pt;";
        echo "    font-family:verdana;";
        echo "    background-color: #73b8bb;";
        echo "}";
        
        echo "table.infomenubartable td:hover {";
        echo "      background-color: #eeeeee;";
        echo "      cursor: pointer;";
        echo "}";        
        echo "</style>";

		echo "<table class='infomenubartable' width='100%' border='0' cellspacing='0'>";

		echo "<tr bgcolor='".$bg."' >";

		echo show_one_info_menu_item( "FAQ", "faq.php" );
		
		echo show_one_info_menu_item( "Policies", "policies.php" );		
		
		echo show_one_info_menu_item( "Costs", "charges.php" );		

//		echo show_one_info_menu_item( "Tips", "tips.php" );
		
		echo show_one_info_menu_item( "About Us", "about_us.php" );		

		echo show_one_info_menu_item( "Contact Us", "contact_us.php" );		

		echo "</tr>";

		echo "</table>";
	}


        // show one item on the information menu bar
        
	function show_one_info_menu_item( $prompt, $page )
	{
		return "<td height='40' style='background-color: #73b8bb' width='4%'></td><td width='8%' align='center' onclick='location.href=\"".url_encode( $page )."\"'>".$prompt."</td><td style='background-color: #73b8bb' width='4%'></td>";
	}


    function get_ip_country_from_country( $country, $cxn_common )
    {
		$query = "SELECT ip_address_name FROM country WHERE display_name = '".$country."'";

		$result = run_query( $query, $cxn_common );

		if (query_num_rows( $result ) > 0)
		{
			$data = get_row( $result );
			
			return ($data['ip_address_name']);
		}
			
        return ("");
    }


        // prevent long lines that don't word wrap, insert spaces if they're not there after commas and full stops
        //
        // inserts a space after each comma and full stop if there isn't one already, except for full stops in email addresses.
        //
        // also inserts a hypen and space after 40 characters without a space
        
        
    function str_insert_spaces( $text )
    {
        $text2 = "";
        $chars_without_space = 0;
        $in_email_address = false;
        
        if (strlen( $text ) > 0)
        {
            for ($i=0; $i < strlen( $text )-1; $i++)
            {
                $ch = substr( $text, $i, 1 );
                
                if ($ch == ",")
                {
                    if (substr( $text, $i+1, 1) != " ")
                    {
                        $text2 .= ", ";
                        $chars_without_space = 0;
                    }
                    else
                        $text2 .= ",";
                        
                    $in_email_address = false;
                }
                else
                if ($ch == ".")
                {
                    if (strpos( substr( $text, $i, 20 ), "@" ) === false && substr( $text, $i+1, 1) != "." && substr( $text, $i+1, 1) != " " && (! $in_email_address))
                    {
                        $text2 .= ". ";
                        $chars_without_space = 0;
                    }
                    else
                        $text2 .= ".";
                }
                else
                    $text2 .= $ch;
                
                if ($ch == "@")    
                    $in_email_address = true;

                if ($ch == " ")
                    $in_email_address = false;
                    
                if ($ch == " ")
                    $chars_without_space = 0;
                else
                    $chars_without_space++;
                    
                if ($chars_without_space >= 40)
                {
                    $text2 .= "- ";
                    $chars_without_space = 0;
                }
            }
    
            $text2 .= substr( $text, strlen($text)-1, 1 );
        }
        
        return ($text2);
    }
    
		/* returns true if the text contains a phone number */

	function check_for_phone_number( $text )
	{
		$has_number = false;
		$points = 0;

		for ($i=0; $i < strlen( $text ); $i++)
		{
			$ch = substr( $text, $i, 1 );

			if ($ch >= "0" && $ch <="9")
		        $points++;
		}

		if ($points >= 6)
    		$has_number = true;

		return ($has_number);
	}

    
	function blue_l( $text )
	{
		return "<span class='gblue_l'>".$text."</span>";
	}

?>