<?php

	include "library.php";

	$cxn = start_code();
	
    $cxn_common = db_common_login();
	

	$start_date = val( $_POST, "start_date" );

	$end_date = val( $_POST, "end_date" );
	

	$report_start_date = convert_date_of_birth( $start_date, "dd/mm/yyyy", $cxn );

	$report_end_date = convert_date_of_birth( $end_date, "dd/mm/yyyy", $cxn );

	
	page_header( "Payments due in the period", $cxn, $cxn_common );
	
	$query = "SELECT * FROM paraplanner_payments LEFT JOIN task ON task.id = paraplanner_payments.task_id WHERE paraplanner_payments.date_completed >= '".$report_start_date."' AND paraplanner_payments.date_completed <= '".$report_end_date."' ORDER BY paraplanner_payments.id";	

	
	$result = run_query( $query, $cxn );
	
	if (query_num_rows( $result ) == 0)
	{
		echo black( "There are no payments listed in this report.<br><br>" );
		
		echo show_home_link();
		
		exit();
	}
	else
	{
		echo "<br><br>";

		echo "<style type='text/css'>\n";
		echo "td ";
		echo " { ";
		echo " padding:0 8px 0 8px; ";
		echo " } ";
		echo "</style>";
		
		echo "<table>";
		
		$total_income = 0;
		
		echo "<tr>";
		echo "<td valign='top' align='center'>".black( "<b>Paraplanner</b>" )."</td>";
		echo "<td valign='top' align='center'>".black( "<b>Task ID</b>" )."</td>";
		echo "<td valign='top' align='center'>".black( "<b>Task Type</b>" )."</td>";		
		echo "<td valign='top' align='center'>".black( "<b>Practice</b>" )."</td>";
		echo "<td valign='top' align='center'>".black( "<b>End Client Name(s)</b>" )."</td>";
		echo "<td valign='top' align='center'>".black( "<b>Amount due</b>" )."</td>";
		echo "<td valign='top' align='center'>".black( "<b>GST</b>" )."</td>";
		echo "<td valign='top' align='center'>".black( "<b>Total</b>" )."</td>";
		echo "<td valign='top' align='center'>".black( "<b>Date Paid</b>" )."</td>";
		
		echo "</tr>";

		echo "<tr><td>&nbsp;</td></tr>";		
		
		$total_due = 0;
		$total_gst = 0;
		$total_total = 0;
		
		for ($i=0; $i < query_num_rows( $result ); $i++)
		{
			$data = get_row( $result );
			
//			$this_working_days = working_days( $data['date_quote_accepted'], $data['date_completed'] );
			
//			if ($this_working_days == -1)
//				$this_working_days = "";
				
			if ($data['date_completed'] == "")
				$date_completed = "";
			else
				$date_completed = format_date_of_birth( substr($data['date_completed'], 0, 10), "dd/mm/yyyy" );

			if (($data['date_paid'] == "") || ($data['date_paid'] == "0000-00-00 00:00:00"))
				$date_paid = "No Paid Date Recorded";
			else
				$date_paid = format_date_of_birth( substr($data['date_paid'], 0, 10), "dd/mm/yyyy" );
			
			if ($data['task_type'] == "soa")
				$task_type_text = "SOA";
			else
			if ($data['task_type'] == "roa")
				$task_type_text = "ROA";
			else
			if ($data['task_type'] == "soariskonly")
				$task_type_text = "Risk Only SOA";
			
			echo "<tr>";
			echo "<td>".black( $data['paraplanner'] )."</td>";
			echo "<td>".black( $data['task_id'] )."</td>";
			echo "<td>".black( $task_type_text )."</td>";
			echo "<td>".black( $data['practice'] )."</td>";
			echo "<td>".black( $data['client_names'] )."</td>";
			echo "<td>".black( $data['amount'] )."</td>";
			echo "<td>".black( $data['GST'] )."</td>";																					
			echo "<td>".black( $data['total'] )."</td>";
			echo "<td>".black( $date_paid )."</td>";																								
			echo "</tr>";
			
			
			$total_due = $total_due + $data['amount'];
			$total_gst = $total_gst + $data['GST'];
			$total_total = $total_total + $data['total'];						
		}
		
		echo "<tr><td>&nbsp;</td></tr>";
		
				
		echo "</table>";
	}			
			
	echo "<br><br><br>";
	
	echo show_home_link();


	function working_days( $date_quote_accepted, $date_completed )
	{
		$working_days = -1;
		
		if ($date_quote_accepted != "" && substr( $date_quote_accepted, 0, 10) != "0000-00-00")
		{
			$start_date = gregoriantojd ( substr( $date_quote_accepted, 5, 2), substr( $date_quote_accepted, 8, 2), substr( $date_quote_accepted, 0, 4) );
			
			if ($date_completed != "")
				$end_date_full = substr( $date_completed, 0, 10 );
			else
				$end_date_full = date("Y-m-d");
	
			$end_date = gregoriantojd ( substr( $end_date_full, 5, 2), substr( $end_date_full, 8, 2), substr( $end_date_full, 0, 4) );
				
			for ($day = $start_date; $day <= $end_date; $day++)
			{
					// 0 = sunday, 6 = saturday
					
				if (jddayofweek( $day ) != 0 && jddayofweek( $day ) != 6)
					$working_days++;
			}
		}
		
		return ($working_days);
	}
?>

